<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Embed Block' component.
 *
 * @ComponentBuilder(
 *   id = "embed_block",
 *   label = @Translation("Embed Block"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "embed_block",
 *   single_value = TRUE,
 *   dependencies = {
 *      "block_field": {
 *         "label" : "Block field",
 *         "url" : "https://www.drupal.org/project/block_field"
 *       }
 *    }
 * )
 */
class EmbedBlock extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_embed_block/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
