<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentItem;
use Drupal\component_builder\Entity\ComponentWrapper;
use Drupal\Core\Render\Markup;

/**
 * Provides 'Life Cycle' component.
 *
 * @ComponentBuilder(
 *   id = "life_cycle",
 *   label = @Translation("Life Cycle"),
 *   group = @Translation("Model"),
 *   category = @Translation("Model"),
 *   template = "life_cycle",
 *   alter_wrapper = TRUE,
 *   single_value = TRUE,
 * )
 */
class LifeCycle extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {

      $component_wrapper = $variables['elements']['#component_wrapper'];
      $number_display_item = 4;
      if ($component_wrapper instanceof ComponentWrapper) {
        $properties = $component_wrapper->get('field_properties')->value;
        if ($properties) {
          $properties = json_decode($properties, TRUE);
          if (isset($properties['properties']['options']['number_display_item'])) {
            $number_display_item = $properties['properties']['options']['number_display_item'];
          }
        }
      }

      if (isset($variables['content']['field_life_cycle'])) {
        $field_life_cycle_item = $variables['content']['field_life_cycle'];
        if (isset($field_life_cycle_item['#items'])) {
          $field_life_cycle_item_items = $field_life_cycle_item['#items'];
          $currentInputItem = count($field_life_cycle_item_items->referencedEntities());
          if ($number_display_item < $currentInputItem) {
            for ($i = $number_display_item; $i < $currentInputItem; $i++) {
              unset($variables['content']['field_life_cycle'][$i]);
            }
          }
        }
      }
    }

    if (isset($variables['elements']['#component_item'])) {
      $component_item = $variables['elements']['#component_item'];
      if ($component_item instanceof ComponentItem) {
        $content = $variables['content'];
        if ($content && isset($content['title']['0']['#context']['value'])) {
          $valueTitle = $content['title']['0']['#context']['value'];
          $markup = Markup::create('<p>' . $valueTitle . '</p>');
          $variables['content']['title']['0']['#context']['value'] = $markup;
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_life_cycle/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_life_cycle/assets/style.js' => [],
        'components/component_life_cycle/assets/jquery.incircle.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
