<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentWrapper;
use Drupal\Core\Render\Element;

/**
 * Provides 'Map Simple' component.
 *
 * @ComponentBuilder(
 *   id = "map_simple",
 *   label = @Translation("Map Simple"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "map_simple",
 *   alter_wrapper = TRUE,
 *   single_value = TRUE,
 *   dependencies = {
 *      "geolocation": {
 *         "label" : "Geolocation Field",
 *         "url" : "https://www.drupal.org/project/geolocation"
 *       },
 *      "geolocation_google_maps": {
 *         "label" : "Geolocation - Google Maps API",
 *         "url" : "https://www.drupal.org/project/geolocation"
 *       },
 *      "geolocation_address": {
 *         "label" : "Geolocation - Address",
 *         "url" : "https://www.drupal.org/project/geolocation"
 *       }
 *    }
 * )
 */
class MapSimple extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      $component_wrapper = $variables['elements']['#component_wrapper'];
      if ($component_wrapper instanceof ComponentWrapper) {
        if (isset($variables['content']['field_map_simple']) && $variables['content']['field_map_simple']) {
          $locations = [];
          foreach (Element::children($variables['content']['field_map_simple']) as $key) {
            $map_simple_item = $variables['content']['field_map_simple'][$key]['#component_item'];
            $location = $map_simple_item->get('field_map_location')->getValue();
            $markup = \Drupal::service('renderer')
              ->render($variables['content']['field_map_simple'][$key]);
            if ($location) {
              $locations[] = [
                $markup,
                $location[0]['lat'],
                $location[0]['lng'],
                $key,
              ];
            }
          }
          $variables['#attached']['drupalSettings']['components']['map_simple']['location'] = json_encode($locations);
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    $library = [];
    $config = \Drupal::config('geolocation_google_maps.settings');
    $settings = $config->get();
    if (isset($settings['google_map_api_key']) && $settings['google_map_api_key']) {
      $key = "&key=" . $settings['google_map_api_key'];
      $js = [
        "https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&sensor=false$key" => [
          'type' => 'external',
          'minified' => TRUE,
        ],
        'components/component_map_simple/assets/style.js' => [],
      ];

      $library = [
        'css' => [
          'theme' => [
            'components/component_map_simple/assets/style.css' => [],
          ],
        ],
        'js' => $js,
        'dependencies' => [
          'core/drupal',
          'core/jquery',
          'core/jquery.once',
        ],
        "version" => "VERSION",
      ];
    }
    return $library;
  }

}
