<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Page not found' component.
 *
 * @ComponentBuilder(
 *   id = "page_not_found",
 *   label = @Translation("Page not found"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "page_not_found",
 *   single_value = TRUE,
 *   alter_wrapper = TRUE
 * )
 */
class PageNotFound extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_page_not_found/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_page_not_found/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
