<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Process style' component.
 *
 * @ComponentBuilder(
 *   id = "process_style",
 *   label = @Translation("Process style"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "process_style"
 * )
 */
class ProcessStyle extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_process_style/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_process_style/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
