<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Sidebar Service' component.
 *
 * @ComponentBuilder(
 *   id = "sidebar_service",
 *   label = @Translation("Sidebar Service"),
 *   group = @Translation("Sidebar"),
 *   category = @Translation("Sidebar"),
 *   template = "sidebar_service",
 *   single_value = TRUE,
 * )
 */
class SidebarService extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_sidebar_service/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_sidebar_service/assets/style.js' => [],
      ],
      "version" => "VERSION",
    ];
  }

}
