<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentItem;

/**
 * Provides 'Slideshow' component.
 *
 * @ComponentBuilder(
 *   id = "slideshow",
 *   label = @Translation("Slideshow"),
 *   group = @Translation("Slider"),
 *   category = @Translation("Slider"),
 *   template = "slideshow"
 * )
 */
class Slideshow extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_item'])) {
      $language = \Drupal::languageManager()->getCurrentLanguage();
      $variables['#attached']['drupalSettings']['components']['slideshow']['rtl'] = $language->getDirection() === 'rtl';

      $component_item = $variables['elements']['#component_item'];
      if ($component_item instanceof ComponentItem) {
        $field_link = $component_item->get('field_link')->getValue();
        if ($field_link) {
          if (!$field_link[0]['title']) {
            if ($variables['content']['title']['0']) {
              $variables['content']['field_link']['0']['#title'] = $variables['content']['title'][0]['#context']['value'];
            }
          }
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_slideshow/assets/style.css' => [],
          'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css' => [
            'type' => 'external',
            'minified' => TRUE,
          ],
        ],
      ],
      'js' => [
        'components/component_slideshow/assets/style.js' => [],
        'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js' => [
          'type' => 'external',
          'minified' => TRUE,
        ],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
