<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Statistic Bar' component.
 *
 * @ComponentBuilder(
 *   id = "statistic_bar",
 *   label = @Translation("Statistic Bar"),
 *   group = @Translation("Information"),
 *   category = @Translation("Information"),
 *   template = "statistic_bar",
 *   single_value = TRUE,
 *   dependencies = {
 *      "color_field": {
 *         "label" : "Color field",
 *         "url" : "https://www.drupal.org/project/color_field"
 *       }
 *    }
 * )
 */
class StatisticBar extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_statistic_bar/assets/style.css' => [],
        ],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
