<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Summary Information' component.
 *
 * @ComponentBuilder(
 *   id = "summary_information",
 *   label = @Translation("Summary Information"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   template = "summary_information",
 *   single_value = TRUE,
 * )
 */
class SummaryInformation extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_summary_information/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
