<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\component_builder\Entity\ComponentWrapper;
use Drupal\Core\Render\Element;

/**
 * Provides 'Tabs Simple' component.
 *
 * @ComponentBuilder(
 *   id = "tabs_simple",
 *   label = @Translation("Tabs Simple"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "tabs_simple",
 *   alter_wrapper = TRUE,
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class TabsSimple extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      $component_wrapper = $variables['elements']['#component_wrapper'];
      if ($component_wrapper instanceof ComponentWrapper) {
        // Set column.
        $number = 1;
        $properties = $component_wrapper->get('field_properties')->value;
        if ($properties) {
          $properties = json_decode($properties, TRUE);
          foreach ($properties as $property) {
            foreach ($property as $key => $elements) {
              if ($key === "styles") {
                if (isset($elements["tab-content-columns"])) {
                  $number = (int) $elements["tab-content-columns"];
                }
              }
            }
          }
        }
        $variables['attributes']['tab-content-columns'][] = "col-tabs-" . $number;
      }

      $field_tab_column = $component_wrapper->get('field_tabs_column')->getValue();
      if (!empty($field_tab_column)) {
        $variables['is_parent'] = TRUE;
        if ($variables['content']['field_tabs_column']) {
          $children_content = Element::children($variables['content']['field_tabs_column']);
          foreach ($children_content as $key) {
            $variables['items'][] = $variables['content']['field_tabs_column'][$key];
          }
        }
      }

      $component_tabs_column = $component_wrapper->get('field_tabs_column')->referencedEntities();
      foreach ($component_tabs_column as $component_wrapper) {
        if ($component_wrapper instanceof ComponentWrapper) {
          $variables['tabs_title'][] = $component_wrapper->getTitle();
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_tabs_simple/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_tabs_simple/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
