<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Topic Summary' component.
 *
 * @ComponentBuilder(
 *   id = "topic_summary",
 *   label = @Translation("Topic Summary"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "topic_summary",
 *   single_value = TRUE,
 *   dependencies = {
 *      "field_group": {
 *         "label" : "Field Group",
 *         "url" : "https://www.drupal.org/project/field_group"
 *       }
 *    }
 * )
 */
class TopicSummary extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath(): string {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries(): array {
    return [
      'css' => [
        'theme' => [
          'components/component_topic_summary/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_topic_summary/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/jquery',
        'core/drupal',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
