<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Video and Text' component.
 *
 * @ComponentBuilder(
 *   id = "video_and_text",
 *   label = @Translation("Video and Text"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   template = "video_and_text",
 *   single_value = TRUE,
 *   dependencies = {
 *      "video": {
 *         "label" : "Video",
 *         "url" : "https://www.drupal.org/project/video"
 *       }
 *    }
 * )
 */
class VideoandText extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_video_and_text/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_video_and_text/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
