# Component Fields

The Component Fields module provides a mechanism for automatically calculating
the value of some ("final") field based on the values of 2 other ("component")
fields of the same type. The final value could be as simple as a copy of one of
the component values or a concatenation/merging of the 2 component values, or
anything else as complex as you can code in a PHP function. This can be done
uniformly on some field for all entities of a given bundle,
or overriden per-entity.

The base idea is to make each component field accessible by different groups of
users (or procedures, like imports), store each component
value in its own field, 
but present a single field as the final, usable value.

## Examples

- A field_text is configured to have field_text_A and
field_text_B as components,
and its value should be the concatenation of the values of field_text_A and f
ield_text_B.
- A field_tags should be the union of the values of
field_tags_A and field_tags_B.
- Some content type is being regularly imported from an external source. The
content moderation team must be able to override the imported values for some
fields, without them being reset on the next import. The imported values can
be stored in field_imported, and the overridden values in field_override. The
field_final can be set to use field_override if it is not empty, otherwise
to use field_imported. The end system will use the field_final, not caring
about the 2 component fields.

## What does the module provide?

A plugin type `ComponentFieldsCompiler`, with a few simple implementations:

- Component 1: The final value is the value of the first component.
- Component 2: The final value is the value of the second component.
- Component 1 with fallback 2: The final value is the value of the
first component, if non empty, or else the second.
- Component 2 with fallback 1: The final value is the value of the
second component, if non empty, or else the first.
- Merge: (Can only be used by multivalue fields) The final value is
the union of the values of the 2 components.
- Empty value: The final value is set explicitly empty.

A configuration page where you can define field combinations
(final + 2 components)
and their default compiler. In another configuration page,
you can enable the option
for per-entity overrides for any bundle that has compilable fields.

A widget for the override field, that presents the list of compilers
as radio buttons for each compilable field.

## What does the module not provide?

The module does not provide any visibility or access control, either for the
final or for the component fields. This is left to the field settings and
permissions which must be set up separately, outside the scope of this module.
It is expected that the final fields will not be writable by anyone, since
their values are calculated on a pre_save hook.

## Configuration

- Enable the module.
- On `admin/config/component-fields/settings` you can see a list of all
content entity types with their bundles. Enable the ones of your
interest and save the form.
- On `admin/config/component-fields/settings/fields` you can see a
fieldset for each one of the enabled bundles. Start adding groups of files:
  - To be able to add a group, the bundle must have at least 3 fields of
  the same type that have not already been used in other groups.
  - First select the final field for this group from the dropdown.
  - Then 2 other dropdowns will appear, one for each of the component fields.
  - After selecting the 2 component fields, a 4th dropdown will appear,
  with the available compilers. Choose the default compiler
  for this field of this bundle.
- On `admin/config/component-fields/settings/overrides` you can enable
the option for per-entity overrides for any bundle that
was previously configured.
  - The overrides are stored in string_long fields as stringified json
  objects. This means that, to enable the overrides for some bundle,
  there needs to be at least one string_long field in the bundle that
  hasn't been configured as part of any composable field group.

## Things to consider

- The compilation of the final value happens on the entity save.
This means that if you change the default compiler for some field,
the final value will not be recalculated for the existing entities.
You must resave each entity, manually either through GUI, drush
command, or any other way in bulk.

## TODO

- Write tests!
- When the default compiler is changed, add some control and
notify the user if there are entities that will be affected by the change.
- Add a way to recalculate the final value for all entities of a bundle.
- Add a way to recalculate only the override values, if exist,
when a default compiler is changed.
- Improve GUI: Merge the enabled-bundles and the fields
configuration pages into a single one?
- Maybe extend the logic to support compilable fields
of different types?
- Maybe extend for more than 2 component fields?
