<?php

namespace Drupal\component_fields\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Component Fields Compiler plugin annotation.
 *
 * This annotation is used to define plugins that calculate final field values
 * based on component fields.
 *
 * @Annotation
 */
final class ComponentFieldsCompiler extends Plugin {

  /**
   * The unique identifier for the plugin.
   *
   * @var string
   */
  public readonly string $id;

  /**
   * The title of the plugin.
   *
   * @var string
   */
  public readonly string $title;

  /**
   * A description of the plugin's functionality.
   *
   * @var string
   */
  public readonly string $description;

  /**
   * Indicates whether this plugin can be used on multivalue fields only.
   *
   * @var bool
   */
  public readonly bool $multivalue_only;

}
