<?php

namespace Drupal\component_fields;

use Drupal\Core\Entity\ContentEntityInterface;

/**
 * Interface for compiling fields in composable entities.
 */
interface CompileServiceInterface {

  /**
   * Updates the provided entity's compilable fields.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity to update.
   */
  public function compileFields(ContentEntityInterface $entity): void;

  /**
   * Returns all string_long fields for a given entity type and bundle.
   *
   * @param string $entity_type_id
   *   The entity type ID.
   * @param string $bundle_id
   *   The bundle ID.
   *
   * @return array
   *   An array of string_long fields.
   */
  public function getStringLongFields(string $entity_type_id, string $bundle_id): array;

  /**
   * Returns all composable fields for all entity types and bundles.
   *
   * @return array
   *   An array of all composable fields.
   */
  public function getAllComposableFields(): array;

  /**
   * Returns composable fields grouped by type for given entity type, bundle.
   *
   * @param string $entity_type_id
   *   The entity type ID.
   * @param string $bundle_id
   *   The bundle ID.
   *
   * @return array
   *   An array of composable fields grouped by their type.
   */
  public function getAllComposableFieldsGroupped(string $entity_type_id, string $bundle_id): array;

}
