<?php

namespace Drupal\component_fields;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Defines the interface for component fields compilers.
 */
interface ComponentFieldsCompilerInterface {

  /**
   * Returns the translated plugin label.
   *
   * @return string
   *   The translated label of the plugin.
   */
  public function label(): string;

  /**
   * Compiles the final field value from the component values.
   *
   * @param mixed $component_1_value
   *   The value of the first component.
   * @param mixed $component_2_value
   *   The value of the second component.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition for the final field.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity containing the field.
   *
   * @return mixed
   *   The field's final compiled value.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed;

}
