<?php

namespace Drupal\component_fields\DTO;

/**
 * Represents a composable field consisting of 2 component fields, final field.
 */
class ComposableField {

  /**
   * The ID of the first component field.
   *
   * @var string
   */
  public readonly string $component1Id;

  /**
   * The ID of the second component field.
   *
   * @var string
   */
  public readonly string $component2Id;

  /**
   * The ID of the final composable field.
   *
   * @var string
   */
  public readonly string $finalId;

  /**
   * The ID of the compiler to use for this composable field.
   *
   * @var string
   */
  public readonly string $compiler;

  /**
   * Constructs a ComposableField object.
   *
   * @param string $component_1_id
   *   The ID of the first component field.
   * @param string $component_2_id
   *   The ID of the second component field.
   * @param string $final_id
   *   The ID of the final composable field.
   * @param string $compiler
   *   The ID of the compiler to use.
   */
  public function __construct(string $component_1_id, string $component_2_id, string $final_id, string $compiler) {
    $this->component1Id = $component_1_id;
    $this->component2Id = $component_2_id;
    $this->finalId = $final_id;
    $this->compiler = $compiler;
  }

}
