<?php

namespace Drupal\component_fields\Form;

use Drupal\component_fields\CompileService;
use Drupal\component_fields\ComponentFieldsCompilerPluginManager;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\ConfigFormBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for component fields configuration forms.
 */
abstract class ComponentFieldsBaseConfigForm extends ConfigFormBase {

  public const SETTINGS = 'component_fields.settings';

  /**
   * The compile service for retrieving composable fields.
   *
   * @var \Drupal\component_fields\CompileService
   */
  protected CompileService $compileService;

  /**
   * The plugin manager for component fields compilers.
   *
   * @var \Drupal\component_fields\ComponentFieldsCompilerPluginManager
   */
  protected ComponentFieldsCompilerPluginManager $componentFieldsPluginManager;

  /**
   * The entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * The entity type bundle info service.
   *
   * @var \Drupal\Core\Entity\EntityTypeBundleInfoInterface
   */
  protected EntityTypeBundleInfoInterface $entityTypeBundleInfo;

  /**
   * The entity field manager service.
   *
   * @var \Drupal\Core\Entity\EntityFieldManagerInterface
   */
  protected EntityFieldManagerInterface $entityFieldManager;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('component_fields.compile_service'),
      $container->get('plugin.manager.component_fields_compiler'),
      $container->get('entity_type.manager'),
      $container->get('entity_type.bundle.info'),
      $container->get('entity_field.manager')
    );
  }

  /**
   * Constructs the ComponentFieldsBaseConfigForm.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The configuration factory.
   * @param \Drupal\component_fields\CompileService $compile_service
   *   The compile service.
   * @param \Drupal\component_fields\ComponentFieldsCompilerPluginManager $compiler_manager
   *   The compiler plugin manager.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\Core\Entity\EntityTypeBundleInfoInterface $entity_type_bundle_info
   *   The entity type bundle info.
   * @param \Drupal\Core\Entity\EntityFieldManagerInterface $entity_field_manager
   *   The entity field manager.
   */
  public function __construct(
    ConfigFactoryInterface $config_factory,
    CompileService $compile_service,
    ComponentFieldsCompilerPluginManager $compiler_manager,
    EntityTypeManagerInterface $entity_type_manager,
    EntityTypeBundleInfoInterface $entity_type_bundle_info,
    EntityFieldManagerInterface $entity_field_manager,
  ) {
    parent::__construct($config_factory);
    $this->compileService = $compile_service;
    $this->componentFieldsPluginManager = $compiler_manager;
    $this->entityTypeManager = $entity_type_manager;
    $this->entityTypeBundleInfo = $entity_type_bundle_info;
    $this->entityFieldManager = $entity_field_manager;
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [static::SETTINGS];
  }

}
