<?php

namespace Drupal\component_fields\Plugin\ComponentFieldsCompiler;

use Drupal\component_fields\ComponentFieldsCompilerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Provides a compiler for Component 1.
 *
 * @ComponentFieldsCompiler(
 *   id = "component_1",
 *   label = @Translation("Component 1"),
 *   description = @Translation("Keep the value of the Component 1."),
 *   multivalue_only = FALSE
 * )
 */
final class Component1 extends ComponentFieldsCompilerBase {

  /**
   * Compiles the value of Component 1.
   *
   * @param mixed $component_1_value
   *   The value of Component 1.
   * @param mixed $component_2_value
   *   The value of Component 2 (not used in this implementation).
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition associated with the component.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being processed.
   *
   * @return mixed
   *   The processed value of Component 1.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed {
    return $component_1_value;
  }

}
