<?php

namespace Drupal\component_fields\Plugin\ComponentFieldsCompiler;

use Drupal\component_fields\ComponentFieldsCompilerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Provides a compiler that retains the value of Component 2.
 *
 * @ComponentFieldsCompiler(
 *   id = "component_2",
 *   label = @Translation("Component 2"),
 *   description = @Translation("Keep the value of the Component 2."),
 *   multivalue_only = FALSE
 * )
 */
final class Component2 extends ComponentFieldsCompilerBase {

  /**
   * Compiles the value by returning the value of Component 2.
   *
   * @param mixed $component_1_value
   *   The value of Component 1 (not used in this implementation).
   * @param mixed $component_2_value
   *   The value of Component 2.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition associated with the component.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being processed.
   *
   * @return mixed
   *   The value of Component 2.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed {
    return $component_2_value;
  }

}
