<?php

namespace Drupal\component_fields\Plugin\ComponentFieldsCompiler;

use Drupal\component_fields\ComponentFieldsCompilerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Provides a compiler that retains value of C2 with fallback to C1.
 *
 * @ComponentFieldsCompiler(
 *   id = "component_2_fallback_1",
 *   label = @Translation("Component 2 with fallback 1"),
 *   description = @Translation("Keep the value of the Component 2 if exists, or else use Component 1."),
 *   multivalue_only = FALSE
 * )
 */
class Component2WithFallback1 extends ComponentFieldsCompilerBase {

  /**
   * Compiles the value by returning Component 2 or falling back to Component 1.
   *
   * @param mixed $component_1_value
   *   The value of Component 1.
   * @param mixed $component_2_value
   *   The value of Component 2.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition associated with the component.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being processed.
   *
   * @return mixed
   *   The value of C2 if it exists, otherwise the value of C1.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed {
    if ($component_2_value) {
      return $component_2_value;
    }
    else {
      return $component_1_value;
    }
  }

}
