<?php

namespace Drupal\component_fields;

use Drupal\component_fields\Annotation\ComponentFieldsCompiler;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages the Component Fields Compiler plugins.
 */
final class ComponentFieldsCompilerPluginManager extends DefaultPluginManager {

  /**
   * Constructs a ComponentFieldsCompilerPluginManager object.
   *
   * @param \Traversable $namespaces
   *   The namespaces for the plugins.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   The cache backend to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler service.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    // @todo implement a custom alter hook with context (for example: the entity itself).
    parent::__construct('Plugin/ComponentFieldsCompiler', $namespaces, $module_handler, ComponentFieldsCompilerInterface::class, ComponentFieldsCompiler::class);
    $this->alterInfo('component_fields_info');
    $this->setCacheBackend($cache_backend, 'component_fields_plugins');
  }

  /**
   * {@inheritdoc}
   */
  public function getDefinitions(bool $exclude_multivalue = FALSE) {
    $all_definitions = parent::getDefinitions();
    if ($exclude_multivalue) {
      foreach ($all_definitions as $key => $definition) {
        if ($definition['multivalue_only']) {
          unset($all_definitions[$key]);
        }
      }
    }

    return $all_definitions;
  }

}
