<?php

namespace Drupal\component_fields\Plugin\ComponentFieldsCompiler;

use Drupal\component_fields\ComponentFieldsCompilerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Provides a compiler that uses Component 1 with a fallback to Component 2.
 *
 * @ComponentFieldsCompiler(
 *   id = "component_1_fallback_2",
 *   label = @Translation("Component 1 with fallback 2"),
 *   description = @Translation("Keep the value of the Component 1 if exists, or else use Component 2."),
 *   multivalue_only = FALSE
 * )
 */
class Component1WithFallback2 extends ComponentFieldsCompilerBase {

  /**
   * Compiles the value by using Component 1 with a fallback to Component 2.
   *
   * @param mixed $component_1_value
   *   The value of Component 1.
   * @param mixed $component_2_value
   *   The value of Component 2.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition associated with the component.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being processed.
   *
   * @return mixed
   *   The value of Component 1 if it exists.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed {
    if ($component_1_value) {
      return $component_1_value;
    }
    else {
      return $component_2_value;
    }
  }

}
