<?php

namespace Drupal\component_fields\Plugin\ComponentFieldsCompiler;

use Drupal\component_fields\ComponentFieldsCompilerBase;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Provides a compiler that sets an empty value.
 *
 * @ComponentFieldsCompiler(
 *   id = "empty_value",
 *   label = @Translation("Empty value"),
 *   description = @Translation("Set an empty value."),
 *   multivalue_only = FALSE
 * )
 */
class EmptyValue extends ComponentFieldsCompilerBase {

  /**
   * Compiles the value by returning NULL.
   *
   * @param mixed $component_1_value
   *   The value of Component 1 (unused).
   * @param mixed $component_2_value
   *   The value of Component 2 (unused).
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field_definition
   *   The field definition associated with the component.
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The entity being processed.
   *
   * @return null
   *   Always returns NULL.
   */
  public function compile(mixed $component_1_value, mixed $component_2_value, FieldDefinitionInterface $field_definition, ContentEntityInterface $entity): mixed {
    return NULL;
  }

}
