# Component Lock

The **Component Lock** module provides site builders with granular control over the configuration forms of Layout Builder components. It allows locking either all settings or specific individual form elements for users without administrative permissions.

## Features

- **Lock All Settings**: Completely hide the component configuration form from non-administrators.
- **Granular Locking**: Choose specific fields (e.g., "Override title", "View mode", etc.) to hide while leaving others editable.
- **Translation Support**: Option to use Drupal's interface translation for the block label.
- **Administrative Override**: Users with the `administer blocks` permission can always see and edit all settings.

## Installation

1. Install the module as usual.
2. Ensure you have the `layout_builder` and `form_decorator` modules installed and enabled.

## Usage

1. Navigate to a Layout Builder enabled entity.
2. Add or configure a block (component).
3. In the configuration form, users with `administer blocks` permission will see two additional tabs:
   - **Lock settings**:
     - **Lock all settings**: If checked, non-admins will not be able to see the "Settings" group at all.
     - **Lock single elements**: If "Lock all settings" is unchecked, you can select specific visible fields to hide from non-admins.
   - **Translation settings**:
     - **Use interface translation for the label**: If checked, the block's label will be passed through the `t()` function during rendering, allowing it to be translated via the Interface Translation UI.

## Requirements

- [Layout Builder](https://www.drupal.org/docs/8/core/modules/layout-builder) (Core)
- [Form Decorator](https://www.drupal.org/project/form_decorator) (Contrib)
