<?php

namespace Drupal\component_lock\EventSubscriber;

use Drupal\layout_builder\Event\SectionComponentBuildRenderArrayEvent;
use Drupal\layout_builder\LayoutBuilderEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Determines component visibility.
 */
class SectionComponentVisibility implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    // Priority is set to 255 so this subscriber is run after the one in
    // BlockComponentRenderArray.
    $events[LayoutBuilderEvents::SECTION_COMPONENT_BUILD_RENDER_ARRAY] = [
      'onBuildRender',
      0,
    ];
    return $events;
  }

  /**
   * Determines the visibility of section components.
   *
   * @param \Drupal\layout_builder\Event\SectionComponentBuildRenderArrayEvent $event
   *   The section component build render array event.
   */
  public function onBuildRender(SectionComponentBuildRenderArrayEvent $event) {
    if ($event->getComponent()->get('label_interface_translation')) {
      $build = $event->getBuild();
      $build['#configuration']['component_lock_translate_label'] = TRUE;
      $event->setBuild($build);
    }

    if ($event->inPreview()) {
      return;
    }
  }

}
