import React from 'react';
import { render, screen } from '@testing-library/react';
import '@testing-library/jest-dom';
import { describe, test, expect, vi } from 'vitest';
import Footer from './Footer.js';

// Mock the conductor image import
vi.mock('../../assets/conductor.png', () => ({
  default: 'mocked-conductor-image.png',
}));

describe('Footer', () => {
  test('renders the footer text', () => {
    render(<Footer />);

    expect(screen.getByText('Powered by')).toBeInTheDocument();
  });

  test('renders the conductor image with correct attributes', () => {
    render(<Footer />);

    const image = screen.getByRole('img');

    expect(image).toBeInTheDocument();
    expect(image).toHaveAttribute('src', 'mocked-conductor-image.png');
    expect(image).toHaveAttribute(
      'alt',
      "A cluster of yellow and green dots with the word 'conductor' written in simple black text to the right of it",
    );
    expect(image).toHaveAttribute('title', 'conductor');
  });

  test('has the correct CSS class for styling', () => {
    render(<Footer />);

    const footerElement = screen.getByText('Powered by');
    expect(footerElement).toHaveClass('conductor__footer');
  });

  test('provides accessible image description', () => {
    render(<Footer />);

    // Check that the alt text provides a meaningful description
    const image = screen.getByAltText(/cluster of yellow and green dots/i);
    expect(image).toBeInTheDocument();
  });

  test('renders as a complete footer section', () => {
    render(<Footer />);

    // Check that both text and image are present in the same container
    const container = screen.getByText('Powered by').parentElement;

    expect(container).toContainElement(screen.getByText('Powered by'));
    expect(container).toContainElement(screen.getByRole('img'));
  });
});
