import { render } from '@testing-library/react';
import { describe, test, expect } from 'vitest';
import FormIndicator from './FormIndicator.js';

describe('FormIndicator', () => {
  test('renders Circle icon when value is an empty string', () => {
    const { container } = render(<FormIndicator value="" valid={false} />);

    const svg = container.querySelector('.lucide-circle');
    expect(svg).toBeInTheDocument();

    const indicator = container.querySelector('.form-indicator');
    expect(indicator).toBeInTheDocument();
  });

  test('renders CircleCheck icon when valid is true and value is not empty', () => {
    const { container } = render(<FormIndicator value="test" valid={true} />);

    const svg = container.querySelector('.lucide-circle-check');
    expect(svg).toBeInTheDocument();
  });

  test('renders CircleX icon when valid is false and value is not empty string', () => {
    const { container } = render(<FormIndicator value="test" valid={false} />);

    const svg = container.querySelector('.lucide-circle-x');
    expect(svg).toBeInTheDocument();
  });

  test('renders Circle icon for empty string regardless of valid prop', () => {
    const { container } = render(<FormIndicator value="" valid={true} />);

    const svg = container.querySelector('.lucide-circle');
    expect(svg).toBeInTheDocument();
  });
});
