/* eslint-disable @typescript-eslint/no-explicit-any */
/// <reference types="vite/client" />

interface ImportMetaEnv {
  readonly DEV: boolean;
  readonly PROD: boolean;
  readonly VITE_APP_NAME?: string; // optional custom variables
}

interface ImportMeta {
  readonly env: ImportMetaEnv;
}

interface Window {
  drupalSettings?: {
    canvas?: {
      store?: Store<any>;
      [key: string]: any;
    };
    conductor?: {
      accountId?: string;
      draftId?: string;
      canvasPageId?: string;
    };
  };
}

declare module '*.css';

declare module '*.svg?react' {
  import type { FunctionComponent, SVGProps } from 'react';
  const content: FunctionComponent<SVGProps<SVGSVGElement>>;
  export default content;
}

declare module '*.svg' {
  const content: string;
  export default content;
}
