<?php

declare(strict_types=1);

namespace Drupal\Tests\conductor\Functional;

use Drupal\canvas\Entity\Page;
use Drupal\Tests\BrowserTestBase;
use Drupal\Tests\conductor\Trait\KeyTrait;

abstract class ConductorBrowserTestBase extends BrowserTestBase {
  use KeyTrait;

  protected function generateBasicCanvasPage(): Page {
    $page = Page::create([
      'title' => "Page " . $this->randomString(),
      'status' => TRUE,
    ]);
    $page->save();
    \assert($page instanceof Page);
    return $page;
  }

}
