import React, { type MouseEventHandler, type ReactNode } from 'react';
import './Button.css';

function Button({
  children,
  onClick = () => {},
  disabled = false,
  type = 'button',
  display = 'primary',
  ...props
}: {
  children: ReactNode | string;
  onClick?: MouseEventHandler<HTMLButtonElement>;
  disabled?: boolean;
  type?: 'button' | 'submit' | 'reset' | undefined;
  display?: 'primary' | 'secondary';
}) {
  return (
    <button
      onClick={onClick}
      disabled={disabled}
      className={`conductor__button ${!disabled ? 'conductor__button--enabled' : ''} conductor__button--${display}`}
      type={type}
      {...props}
    >
      {children}
    </button>
  );
}

export default Button;
