import { render, waitFor, screen } from '@testing-library/react';
import ContentOutline from './ContentOutline.js';
import { AppStateProvider, type Draft, useDraft, useDrupal } from '../Context.js';
import { vi } from 'vitest';

vi.mock('../../assets/lightbulb.svg?react', () => ({
  default: () => <div data-testid="lightbulb-icon">Lightbulb</div>,
}));

describe('Content Outline', () => {
  test('No fields shown when no keywords or < 10 competitor URLs provided', async () => {
    const initialState = {
      accountId: '12345',
      drupal: {
        entity: {
          id: 1,
          type: 'canvas_page',
        },
        draftLinked: false,
      },
      keywords: [],
      competitorUrls: ['https://www.instagram.com/grittynhl/'],
    };

    render(
      <AppStateProvider initialState={initialState}>
        <ContentOutline />
      </AppStateProvider>,
    );

    await waitFor(() => {
      expect(
        screen.getByText(/Keywords and at least 10 competitor URLs are required/i),
      ).toBeInTheDocument();
    });
  });

  test('Draft is created and linked', async () => {
    const initialState = {
      accountId: '12345',
      drupal: {
        entity: {
          id: 1,
          type: 'canvas_page',
        },
        draftLinked: false,
      },
      keywords: ['gritty', 'phanatic', 'swoop'],
      competitorUrls: [
        'https://www.instagram.com/grittynhl/',
        'https://en.wikipedia.org/wiki/Gritty',
        'https://www.nhl.com/flyers/fans/gritty',
        'https://www.tiktok.com/@grittynhl?lang=en',
        'https://grittys.com',
        'https://www.merriam-webster.com/dictionary/gritty',
        'https://www.instagram.com/reel/DLC8pxqRxqf/?hl=en',
        'https://975thefanatic.com/listicle/top-6-gritty-moments/',
        'https://www.tiktok.com/@grittynhl/video/7517302191233797407',
        'https://www.reddit.com/r/Gritty/',
      ],
    };

    let draft: Draft = {
      title: 'Untitled Canvas draft',
    };
    let drupal = { draftLinked: false };
    const ContextCapture = () => {
      draft = useDraft();
      drupal = useDrupal();
      return null;
    };
    render(
      <AppStateProvider initialState={initialState}>
        <ContentOutline />
        <ContextCapture />
      </AppStateProvider>,
    );

    await waitFor(() => {
      expect(draft.id).toBe('bead88f1-bd37-48a7-9861-46f04058141d');
    });
    await waitFor(() => {
      expect(drupal.draftLinked).toBe(true);
    });
  });
});
