<?php

declare(strict_types=1);

namespace Drupal\Tests\conductor\Functional;

use Drupal\Core\Session\AccountInterface;

/**
 * Tests the conductor proxy endpoints with Redirect module enabled.
 */
final class ConductorProxyRedirectModuleTest extends ConductorBrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'redirect',
    'conductor',
    'conductor_test',
    'key',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->generateKey();

    // Enable the "Enforce clean and canonical URLs" option.
    $redirect_settings = $this->config('redirect.settings');
    $redirect_settings->set('route_normalizer_enabled', TRUE)->save();
  }

  /**
   * Tests that the conductor proxy endpoint returns a valid response.
   */
  public function testProxyEndpointWithRouteNormalizerEnabled(): void {
    $account = $this->drupalCreateUser(['use conductor', 'access content']);
    assert($account instanceof AccountInterface);
    $this->drupalLogin($account);
    $this->assertTrue($this->drupalUserIsLoggedIn($account));
    $this->drupalGet('/conductor/proxy/v3/accounts');
    $this->assertSession()->statusCodeEquals(200);
  }

}
