import React, { useState } from 'react';
import { AppStateProvider } from './Context.js';
import { Tab, TabList, TabPanel, Tabs } from 'react-tabs';
import Keywords from './pages/Keywords.js';
import Competitors from './pages/Competitors.js';
import ContentOutline from './pages/ContentOutline.js';
import Footer from './components/Footer.js';
import './App.css';
import ErrorBoundary from './utilities/ErrorBoundary.js';

function AppInner() {
  const [tabIndex, setTabIndex] = useState(0);

  return (
    <Tabs className="conductor" selectedIndex={tabIndex} onSelect={(index) => setTabIndex(index)}>
      <TabList className="conductor__tab-list">
        <Tab className="conductor__tab">Keywords</Tab>
        <Tab className="conductor__tab">Competitors</Tab>
        <Tab className="conductor__tab">Content outline</Tab>
      </TabList>
      <TabPanel className="conductor__tab-panel">
        <Keywords setTab={(index: number) => setTabIndex(index)} nextTab={1} />
      </TabPanel>
      <TabPanel className="conductor__tab-panel">
        <Competitors setTab={(index: number) => setTabIndex(index)} nextTab={2} />
      </TabPanel>
      <TabPanel className="conductor__tab-panel">
        <ContentOutline />
      </TabPanel>
      <Footer />
    </Tabs>
  );
}

function App() {
  const [appKey, setAppKey] = useState(0);

  const accountId = window?.drupalSettings?.conductor?.accountId ?? '';
  const draftId = window?.drupalSettings?.conductor?.draftId ?? '';
  let entityId = 0;
  let entityType = '';
  if (window.location.pathname.startsWith('/canvas/editor/')) {
    const parts = window.location.pathname.split('/').filter(Boolean);
    // The parameter is `/canvas/editor/{entity_type}/{entity_id}
    const tmpEntityId = parts.pop() ?? '';
    entityId = tmpEntityId.length ? parseInt(tmpEntityId) : 0;
    entityType = parts.pop() ?? '';
  } else {
    entityId = window?.drupalSettings?.canvas?.entityId
      ? parseInt(window.drupalSettings.canvas.entityId)
      : 0;
    entityType = window?.drupalSettings?.canvas?.entityType ?? '';
  }

  if (!accountId) {
    return 'No conductor account ID found.';
  }

  if (!entityType || !entityId) {
    return 'Please open a Canvas page before using this extension.';
  }

  return (
    <ErrorBoundary onReset={() => setAppKey((k) => k + 1)}>
      <AppStateProvider
        key={appKey}
        initialState={{
          accountId,
          draft: { id: draftId },
          drupal: { entity: { type: entityType, id: entityId }, draftLinked: draftId.length > 0 },
        }}
      >
        <AppInner />
      </AppStateProvider>
    </ErrorBoundary>
  );
}

export default App;
