import React, { type MouseEventHandler, type ReactNode } from 'react';
import './Button.css';

function Button({
  children,
  onClick = () => {},
  disabled = false,
  type = 'button',
  variant = 'solid',
  size = '2',
  ...props
}: {
  children: ReactNode | string;
  onClick?: MouseEventHandler<HTMLButtonElement>;
  disabled?: boolean;
  type?: 'button' | 'submit' | 'reset' | undefined;
  variant?: 'solid' | 'surface';
  size?: '1' | '2';
}) {
  return (
    <button
      onClick={onClick}
      disabled={disabled}
      className={`conductor__button conductor__button--${variant} conductor__button--size-${size}`}
      type={type}
      {...props}
    >
      {children}
    </button>
  );
}

export default Button;
