import type { Drupal } from '@drupal/playwright';
import { expect, type Locator, type Page } from '@playwright/test';

import type { Canvas } from './Canvas.js';

export class Conductor {
  readonly page: Page;
  readonly drupal: Drupal;
  readonly canvas: Canvas;

  constructor({ page, drupal, canvas }: { page: Page; drupal: Drupal; canvas: Canvas }) {
    this.page = page;
    this.drupal = drupal;
    this.canvas = canvas;
  }

  async open(): Promise<Locator> {
    await this.drupal.login({ username: 'editor', password: 'editor' });
    await this.canvas.openCanvas(await this.canvas.createCanvas());
    await this.page
      .locator('[data-testid="canvas-side-menu"]')
      .getByRole('button', { name: 'Extensions' })
      .click();
    await this.page
      .locator('[data-testid="canvas-primary-panel"]')
      .getByRole('button', { name: 'Acquia SEO' })
      .click();
    await expect(this.page.getByRole('heading', { name: 'Acquia SEO' })).toBeVisible();
    await expect(
      this.page
        .locator('#extensionPortalContainer')
        .getByRole('tablist')
        .and(this.page.locator('ul')),
    ).toBeVisible();
    return this.page.locator('#extensionPortalContainer');
  }

  async initializeKeywordsAndCompetitorUrls(app: Locator): Promise<void> {
    // We require to have keywords and competitors to enable tabs
    await app.getByRole('textbox').fill('jawn');
    await app.getByRole('textbox').press('Enter');
    // Click on Competitors to generate competitors
    await expect(app.getByRole('tab', { name: 'Competitors' })).toBeVisible();
    await app.getByRole('tab', { name: 'Competitors' }).click();
    // Click back on Keywords to start the process
    await expect(app.getByRole('tab', { name: 'Keywords' })).toBeVisible();
    await app.getByRole('tab', { name: 'Keywords' }).click();
  }
}
