import React from 'react';
import { Info } from 'lucide-react';
import './InfoBar.css';

const InfoBar = ({ children }: { children: React.ReactElement | string }) => {
  return (
    <div className={'conductor__info-bar'}>
      <div className="conductor__info-bar-content">
        <span className="conductor__info-bar-icon">
          <Info size={16} />
        </span>
        <span className="conductor__info-bar-message">{children}</span>
      </div>
    </div>
  );
};

export default InfoBar;
