import { describe, test, expect } from 'vitest';
import { render, screen, waitFor } from '@testing-library/react';
import Loading from './Loading.js';

describe('Loading component', () => {
  test('applies base CSS class', () => {
    render(<Loading />);

    const loading = screen.getByRole('status');
    expect(loading).toHaveClass('conductor__loading');
  });
});

export async function waitForLoading() {
  const loadingSpinner = screen.getByRole('status');
  expect(loadingSpinner).toBeInTheDocument();

  await waitFor(
    () => {
      const loadingSpinner = screen.queryByText(/loading/i);
      expect(loadingSpinner).not.toBeInTheDocument();
    },
    { timeout: 3000 },
  );
}
