import { expect, type Page } from '@playwright/test';

export class Canvas {
  readonly page: Page;

  constructor({ page }: { page: Page }) {
    this.page = page;
  }

  async createCanvas() {
    const tokenResponse = await this.page.request.get('/session/token');
    const token = await tokenResponse.text();
    const response = await this.page.request.post('/canvas/api/v0/content/canvas_page', {
      headers: {
        'content-type': 'application/json',
        'x-csrf-token': token,
      },
      data: {},
    });
    expect(response.ok()).toBeTruthy();
    const data = await response.json();
    const { entity_type, entity_id } = data;
    expect(entity_type).toBeTruthy();
    expect(entity_id).toBeTruthy();
    return data;
  }

  async openCanvas({ entity_type, entity_id }: { entity_type: string; entity_id: number }) {
    await this.page.goto(`/canvas/editor/${entity_type}/${entity_id}`);
    await this.page.waitForLoadState('domcontentloaded');
    await expect(this.page.getByTestId('canvas-contextual-panel--page-data')).toBeVisible();
    await expect(this.page.getByTestId('canvas-side-menu')).toBeVisible();
    await expect(this.page.getByTestId('canvas-publish-review')).toBeVisible();
    await expect(
      this.page.locator('#canvasPreviewOverlay').getByText('Place items here'),
    ).toBeVisible();
  }
}
