import { expect } from '@playwright/test';

import { parallelWorker as test } from '../fixtures/test.js';

test.describe('Drafts', () => {
  test('Draft ID is successfully stored in Drupal', async ({ conductor, page }) => {
    const app = await conductor.open();

    await conductor.initializeKeywordsAndCompetitorUrls(app);

    await expect(app.getByRole('tab', { name: 'Content outline' })).toBeVisible();
    await app.getByRole('tab', { name: 'Content outline' }).click();
    await page.locator('.conductor__loading').waitFor({ state: 'detached' });
    await expect(app.getByText('Title tag')).toBeVisible();
    await page.waitForLoadState('networkidle');
    await page.reload();

    const draftId = await page.evaluate(() => {
      return window.drupalSettings?.conductor?.draftId;
    });
    expect(draftId).toBe('bead88f1-bd37-48a7-9861-46f04058141d');
  });
});
