<?php

declare(strict_types=1);

use Drupal\key\Entity\Key;

// @see Drupal\conductor\Tests\Trait\KeyTrait::generateKey()
$values = [
  'id' => 'conductor_test_key',
  'label' => 'Conductor Test Key',
  'description' => 'Key for testing Conductor module',
  'key_type' => 'authentication',
  'key_provider' => 'config',
  'key_input' => 'text_field',
  'key_input_settings' => [],
  'key_provider_settings' => [
    'key_value' => json_encode([
      'api_key' => 'test_api_key',
      'shared_secret' => 'test_secret',
    ]),
  ],
];

Key::create($values)->save();

$config = \Drupal::configFactory()->getEditable('conductor.settings');
$config->set('key_id', 'conductor_test_key')->save();
