# Conductor

Conductor is an SEO focused AI writing assistant with
[Drupal Canvas](https://drupal.org/project/canvas) integration.

## Installation

- Add the module
  ```
  composer require drupal/conductor
  ```
- Enable the module at `/admin/modules`.
- Generate an API key and secret in Conductor from `Integrations / API` in the dashboard menu.
- Add the credentials at `/admin/config/system/keys/add` The key can have any name the type should
  be set to `Authentication (Multivalue)`. The format of the credentials is:
  ```json
  {
    "api_key": "{api_key}",
    "shared_secret": "{shared_secret}"
  }
  ```
  See the [Key module documentation](https://www.drupal.org/docs/contributed-modules/key) for more
  information on configuration options and security.
- Go to `/admin/config/search/conductor` and select the newly created key.

Then enable the module in Drupal. The extension will then be available from the Extensions button in
the left-hand sidebar in Canvas.

## Development

When using a git clone of this module you will need to build the app manually:

```
cd web/modules/contrib/conductor
npm ci
npm run build
```

To run a local copy of the application, standalone from Canvas, run:

```
npm run dev -w app
```

### Testing

See [docs/testing.md](docs/testing.md)
