import React from 'react';
import { render, screen } from '@testing-library/react';
import { userEvent } from '@testing-library/user-event';
import '@testing-library/jest-dom';
import { describe, expect, test } from 'vitest';
import DraftUsageAlert from './DraftUsageAlert.js';

describe('DraftUsageAlert', () => {
  test('shows "No drafts remaining" when no drafts are left', () => {
    render(<DraftUsageAlert maxDrafts={3} usedDrafts={3} />);

    expect(screen.getByText(/No drafts remaining\./i)).toBeInTheDocument();
  });

  test('displays the correct usage counts in the alert message', () => {
    render(<DraftUsageAlert maxDrafts={5} usedDrafts={4} />);

    expect(
      screen.getByText('You have used 4 out of 5 of your writing drafts.'),
    ).toBeInTheDocument();
  });

  test('onClick is called', async () => {
    const user = userEvent.setup();
    const handleClick = vi.fn();
    render(<DraftUsageAlert maxDrafts={9} usedDrafts={7} onClick={handleClick} />);

    expect(screen.getByRole('alert')).toBeInTheDocument();
    await user.click(screen.getByRole('button', { name: /close alert/i }));
    expect(handleClick).toHaveBeenCalledTimes(1);
  });
});
