import React from 'react';
import { X } from 'lucide-react';
import './DraftUsageAlert.css';

const DraftUsageAlert = ({
  onClick = () => {},
  maxDrafts,
  usedDrafts,
}: {
  onClick?: () => void;
  maxDrafts: number;
  usedDrafts: number;
}) => {
  return (
    <div className="conductor-draft-usage-alert" role="alert">
      <div className="conductor-draft-usage-alert__content">
        <span className="conductor-draft-usage-alert__message">
          {usedDrafts >= maxDrafts && (
            <span className="conductor-draft-usage-alert__emphasis"> No drafts remaining.</span>
          )}
          You have used {usedDrafts} out of {maxDrafts} of your writing drafts.
        </span>
        <button
          type="button"
          className="conductor-draft-usage-alert__close"
          aria-label="Close alert"
          onClick={onClick}
        >
          <X />
        </button>
      </div>
    </div>
  );
};

export default DraftUsageAlert;
