import React from 'react';
import { Circle, CircleX, CircleCheck } from 'lucide-react';
import './FormIndicator.css';

export default function FormIndicator({ value, valid }: { value: string; valid: boolean }) {
  const getCircle = () => {
    if (value.length === 0) {
      return <Circle />;
    }

    if (valid) {
      return <CircleCheck />;
    }

    return <CircleX />;
  };

  return (
    <div
      className="form-indicator"
      data-testid="form-indicator"
      data-valid={value?.length && valid}
    >
      {getCircle()}
    </div>
  );
}
