import React from 'react';
import { Info } from 'lucide-react';
import './InfoBar.css';

const InfoBar = ({ children }: { children: React.ReactElement | string }) => {
  return (
    <div className={'info-bar'}>
      <div className="info-bar__content">
        <span className="info-bar__icon">
          <Info size={16} />
        </span>
        <span className="info-bar__message">{children}</span>
      </div>
    </div>
  );
};

export default InfoBar;
