import React, { type MouseEventHandler } from 'react';
import { X } from 'lucide-react';
import './Tag.css';

function Tag({
  children,
  remove,
}: {
  children: string;
  remove?: MouseEventHandler<HTMLButtonElement>;
}) {
  return (
    <span className="tag">
      {children}
      {remove && (
        <button
          onClick={remove}
          className="tag__remove"
          type="button"
          aria-label={`Remove ${children}`}
        >
          <X />
        </button>
      )}
    </span>
  );
}

export default Tag;
