<?php

declare(strict_types=1);

namespace Drupal\conductor\Repository;

interface DraftRepositoryInterface {

  public function getDrafts(?int $year = NULL): array;

  public function getDraft(string $entity_type, int $entity_id): array;

  public function createDraft(string $entity_type, int $entity_id, string $draft_id): void;

  public function updateDraft(string $entity_type, int $entity_id, string $draft_id): void;

  public function upsertDraft(string $entity_type, int $entity_id, string $draft_id): void;

  public function deleteDraft(string $entity_type, int $entity_id): bool;

  public function isDraftLinkedToAnEntity(string $draft_id): bool;

  public function getMaxDrafts(): int;

  public function getUsedDrafts(): int;

}
