/** @type {import('stylelint').Config} */
import { readFileSync } from 'node:fs';

import parseGitignore from 'parse-gitignore';

const gitignorePatterns = parseGitignore(readFileSync('.gitignore', 'utf8')).patterns.map(
  (pattern) => {
    // Convert to Stylelint-compatible patterns
    return pattern.includes('*') ? pattern : `**/${pattern}`;
  },
);

import sortOrderSmacss from 'stylelint-config-property-sort-order-smacss/generate.js';
export default {
  extends: 'stylelint-config-property-sort-order-smacss',
  rules: {
    'order/properties-order': [sortOrderSmacss({ emptyLineBefore: 'always' })],
    'selector-class-pattern': [
      '^[a-z]([a-z0-9-]+)?(__[a-z0-9-]+)?(--[a-z0-9-]+)?$',
      {
        message: 'Expected class selector to be BEM format',
      },
    ],
  },
  ignoreFiles: gitignorePatterns,
};
