<?php

declare(strict_types=1);

namespace Drupal\Tests\conductor\Trait;

use Drupal\TestTools\Random;

trait DraftTrait {

  private function createHistoricalDraft(int $year, ?string $draft_id = NULL, ?int $entity_id = NULL, ?string $entity_type = NULL): void {
    \Drupal::service('database')->insert('conductor_draft_map')
      ->fields([
        'entity_id' => $entity_id ?? random_int(1000, 10000),
        'entity_type' => $entity_type ?? 'canvas_page',
        'draft_id' => $draft_id ?? Random::string(8),
        // We want to insert a draft right before the end of the year.
        'created' => strtotime("last day of december $year 23:59:59"),
        'changed' => strtotime("last day of december $year 23:59:59"),
      ])
      ->execute();
  }

}
